/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : DIVIDE-BY-TWELVE COUNTERS
TRUTHTABLE     : 

         BCD COUNT SEQUENCE         RESET/COUNT TABLE
         -------------------   --------------------------
         COUNT  QD QC QB QA    R_0_1   R_0_2    QD QC QB QA
         -------------------   --------------------------
           0    L  L  L  L      H     H         L  L  L  L
           1    L  L  L  H      X     L           COUNT
           2    L  L  H  L      L     X           COUNT
           3    L  L  H  H     --------------------------
           4    L  H  L  L    
           5    L  H  L  H    
           6    H  L  L  L    
           7    H  L  L  H
           8    H  L  H  L
           9    H  L  H  H
          10    H  H  L  L
          11    H  H  L  H
         -------------------  
                                            
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : June 1994 

VERITOOL COMPATIBILITY  : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a92 (ckb, r01, r02, qd, qc, qb, qa, cka);
	parameter size =1;
	input
		ckb,
		r01,
		r02,
		cka;
	output
		qd,
		qc,
		qb,
		qa;
    reg
        NOTIFY_REG;
    nand
	  (en, r01, r02);
    nand  
	N92N_inst_N1 (n92n_inst_clrb, r01, r02);
    not
	  (n92n_inst_qcb, n92n_inst_qcint);
    not
	  (n92n_inst_ncka, cka);
    not  
	  (n92n_inst_nckb, ckb);
    buf
	  (qa, n92n_inst_qaint);
    buf
	  (qb, n92n_inst_qbint);
    buf  
	  (qc, n92n_inst_qcint);
    buf
	  (qd, n92n_inst_qdint);
    U_FJK_P_RB_NO  
	  (n92n_inst_qaint, 1'b1, 1'b1, n92n_inst_ncka, n92n_inst_clrb, NOTIFY_REG);
    U_FJK_P_RB_NO  
	  (n92n_inst_qbint, n92n_inst_qcb, 1'b1, n92n_inst_nckb, dd_net_16, NOTIFY_REG);
    U_FJK_P_RB_NO
	  (n92n_inst_qcint, n92n_inst_qbint, 1'b1, n92n_inst_nckb, n92n_inst_clrb, NOTIFY_REG);
    U_FJK_P_RB_NO  #(0, 6:12:18)
	  (n92n_inst_qdint, 1'b1, 1'b1, n92n_inst_qcb, n92n_inst_clrb, NOTIFY_REG);
    buf  
	  (dd_net_16, n92n_inst_clrb);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
